# FAX送信票自動添付アプリ

## 📖 概要
PDFや画像ファイルに、FAX送信票を自動で追加するWebアプリケーションです。
インターネット接続不要で、ブラウザだけで動作します。

## 🚀 使い方

### 1. 起動方法
`fax_cover_app.html` をダブルクリックしてブラウザで開くだけです。
**インターネット接続は不要です！**

### 2. 基本的な使い方

#### ①送信元情報を設定（初回のみ）
1. 「⚙️ 送信元設定（初期設定）」をクリック
2. 機関名、部署名、担当者名、電話番号、FAX番号を入力
3. 「送信元情報を保存」をクリック

**一度保存すれば、次回以降は自動で入力されます。**

#### ②宛先情報を入力
1. 宛先機関名、部署名、担当者名を入力
2. 件名とメッセージを入力（任意）

**よく使う宛先は「現在の入力をリストに保存」で保存できます。**
次回は「リストから読み込み」ボタンで呼び出せます。

#### ③ファイルを選択
1. 点線の枠内にPDF/PNG/JPGファイルをドラッグ&ドロップ
2. または枠をクリックしてファイルを選択

#### ④PDF生成
「FAX送信票付きPDFを生成」ボタンをクリックすると、送信票が先頭に追加されたPDFがダウンロードされます。

### 3. 便利な機能

#### 📋 宛先リスト機能
- よく使う宛先を保存して再利用できます
- 「宛先・件名リストを管理」で編集・削除が可能

#### 🔒 個人情報マスク機能
- プレビュー画面で、マスクしたい箇所をクリック&ドラッグで選択
- 黒い四角でマスクされます
- 右クリックでマスクを削除
- 自動検出機能もあります（完璧ではないので要確認）

## 📁 ファイル構成
```
Fax_cover_app/
├── fax_cover_app.html      （メインアプリ - これを開く）
├── manifest.json            （PWA設定）
├── service-worker.js        （PWA用）
├── README_OFFLINE.md        （このファイル）
└── libs/                    （必須ライブラリ - 削除しないでください）
    ├── pdf.min.js
    ├── pdf.worker.min.js
    ├── jspdf.umd.min.js
    ├── html2canvas.min.js
    └── fonts/
        ├── noto-sans-jp.css
        ├── noto-sans-jp-400.ttf
        └── noto-sans-jp-700.ttf
```

## 📱 対応環境
- ✅ Chrome
- ✅ Edge
- ✅ Safari
- ✅ Firefox

## 💡 特徴
- ✅ **インターネット接続不要** - すべてのライブラリをローカルに内蔵
- ✅ **個人情報保護** - データはすべて端末内で処理、外部に送信されません
- ✅ **簡単操作** - ドラッグ&ドロップで即座にPDF生成
- ✅ **設定保存** - 送信元情報や宛先リストを保存可能

## 🔧 トラブルシューティング

### PDFが生成できない場合
- `libs/` フォルダが同じ場所にあるか確認
- ファイル形式がPDF、PNG、JPGであるか確認
- ブラウザのコンソールでエラーを確認

### フォントが表示されない場合
- `libs/fonts/` フォルダ内のフォントファイルがあるか確認

## 📌 その他

### PWAとしてインストール（オプション）
Webサーバー経由でアクセスすると、アプリとしてインストールできます。

```bash
# Python 3でWebサーバーを起動
python -m http.server 8000
```

その後、`http://localhost:8000/fax_cover_app.html` にアクセスし、ブラウザの「インストール」ボタンをクリック。

### データの保存場所
- 送信元情報と宛先リストはブラウザのローカルストレージに保存されます
- ブラウザのデータを削除すると、保存した情報も削除されます
